<?php
extract ( shortcode_atts ( array (
	'type' => '',
	'columns' => '4',
	'current_step' => '0',
	'step_style' => '',
	'theme' => '',
	'values' => '',
	'css_animation' => '',
	'animation_delay' => '',
	'el_class' => '', 
), $atts ) );

$type = sm_validate_with_array( $type, sm_get_progress_steps_type_array() );
$columns = sm_validate_with_array( $columns, sm_get_progress_steps_columns_array() );
$step_style = sm_validate_with_array( $step_style, sm_get_progress_steps_style_array() );
$theme = sm_validate_with_array( $theme, sm_get_skins_array( true ) );
$values = (array) sm_param_group_parse_atts( $values );

if ( 'sm-type1' == $type ) {
	$css_class = array( 'sm-progress-steps', 'sm_content_element', 'clearfix' );
	$css_class[] = 'columns-' . $columns;
	$css_class[] = $step_style;
	$css_class[] = $theme;

	$css_class = implode( ' ', $css_class );
	$css_class .= sm_get_extra_class( $el_class );
	$css_class .= sm_get_css_animation( $css_animation );

	$wrapper_attributes = array();
	$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
	if ( intval( $animation_delay ) > 0 ) {
		$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );
	}

	$total_number = count( $values );

	?>
	<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<?php
	$step_number = 1;
	foreach( $values as $value ) :
		$status = 'remaining';
		if( $step_number < $current_step ) :
			$status = 'done';
		elseif( $step_number == $current_step ) :
			$status = 'active';
		endif;
		$step_icon = sm_get_icon_from_atts( $value, true );
		$step_title = !empty( $value['title'] ) ? $value['title'] : '';
		$step_text = !empty( $value['text'] ) ? $value['text'] : '';
	?>
		<div class="step <?php echo esc_attr( $status ); ?>">
			<div class="ps-circle-wrap">
			<?php if( $step_style == 'sm-style-icon' ) : ?>
				<span><i class="<?php echo esc_attr( $step_icon ); ?>"></i></span>
			<?php else : ?>
				<span><?php echo esc_attr( $step_number ); ?></span>
			<?php endif; ?>
			</div>
			<div class="ps-info-wrap">
				<h6 class="ps-title"><?php echo esc_html( $step_title ); ?></h6>
				<div class="ps-text"><?php echo sm_do_kses( wpautop( html_entity_decode( $step_text ) ) ); ?></div>
			</div>
		</div>
	<?php
		if ( $step_number < $total_number ) {
			if ( ( $columns == 6 && $step_number % 3 == 0 ) ||
				 ( $columns == 5 && $step_number % 2 == 0 ) ||
				 ( $columns == 4 && $step_number % 2 == 0 ) )
				echo '<div class="ps-clearfix"></div>';
		}
		$step_number ++;
	endforeach;
	?>
	</div>
<?php
} else if ( 'sm-type2' == $type ) {
	$side = array( 'right', 'left' );
	$step_number = 0;
?>
<div class="sm-progress-steps2">
	<?php foreach( $values as $value ) : ?>
		<?php
		++ $step_number;
		$pos_class = '';
		if ( 1 == $step_number ) $pos_class = ' first';
		if ( count( $values ) == $step_number ) $pos_class = ' last';
		$step_icon = sm_get_icon_from_atts( $value );
		$step_title = !empty( $value['title'] ) ? $value['title'] : '';
		$step_text = !empty( $value['text'] ) ? $value['text'] : '';
		?>
		<div class="workflow-step <?php echo esc_attr( $side[$step_number % 2] . $pos_class ); ?> style-gray">
			<div class="step-icon">
				<i class="<?php echo esc_attr( $step_icon ); ?>"><?php if ( '' == $step_icon ) : echo esc_html( $step_number ); endif; ?></i>
			</div>
			<div class="workflow-content">
				<h3 class="title"><?php echo esc_html( $step_title ); ?></h3>
				<div class="text"><?php echo sm_do_kses( wpautop( html_entity_decode( $step_text ) ) ); ?></div>
			</div>
			<div class="flowline"></div>
		</div>
	<?php endforeach; ?>
</div>
<?php 
} else if ( 'sm-type3' == $type ) {
	$css_class = array( 'sm-progress-steps3', 'sm_content_element', 'clearfix' );
	$css_class[] = 'columns-' . $columns;

	$css_class = implode( ' ', $css_class );
	$css_class .= sm_get_extra_class( $el_class );
	$css_class .= sm_get_css_animation( $css_animation );

	$wrapper_attributes = array();
	$wrapper_attributes[] = 'class="' . esc_attr( $css_class ) . '"';
	if ( intval( $animation_delay ) > 0 ) {
		$wrapper_attributes[] = sm_get_animation_delay_attribute( $animation_delay );
	}

	$total_number = count( $values );

	?>
	<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<?php
	$step_number = 1;
	foreach( $values as $value ) :
		$status = 'remaining';
		if( $step_number < $current_step ) :
			$status = 'done';
		elseif( $step_number == $current_step ) :
			$status = 'active';
		endif;
		$step_icon = sm_get_icon_from_atts( $value, true );
		$step_title = !empty( $value['title'] ) ? $value['title'] : '';
		$step_text = !empty( $value['text'] ) ? $value['text'] : '';
	?>
		<div class="step <?php echo esc_attr( $status ); ?>">
			<div class="ps-rect-wrap">
				<span class="step-icon"><i class="<?php echo esc_attr( $step_icon ); ?>"></i></span>
				<span class="step-number"><?php echo esc_attr( $step_number ); ?></span>
			</div>
			<?php if ( $step_number < $total_number ) : ?>
				<div class="ps-arrow-icon"><i class="fa fa-angle-right"></i></div>
			<?php endif; ?>
			<div class="ps-info-wrap">
				<h6 class="ps-title"><?php echo esc_html( $step_title ); ?></h6>
				<div class="ps-text"><?php echo sm_do_kses( wpautop( html_entity_decode( $step_text ) ) ); ?></div>
			</div>
		</div>
	<?php
		if ( $step_number < $total_number ) {
			if ( ( $columns == 6 && $step_number % 3 == 0 ) ||
				 ( $columns == 5 && $step_number % 2 == 0 ) ||
				 ( $columns == 4 && $step_number % 2 == 0 ) )
				echo '<div class="ps-clearfix"></div>';
		}
		$step_number ++;
	endforeach;
	?>
	</div>
<?php
}
?>